



<html>
<head>
  <title>javabog.dk -  - Grafiske standardkomponenter</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">11 <a name='afsn11'></a>Grafiske
standardkomponenter</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Design
  af en grafisk brugergr&aelig;nseflade med et udviklingsv&aelig;rkt&oslash;j</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">De vigtigste
  grafiske komponenter og deres egenskaber</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Containere og
  layout-managere</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Menuer</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;ttes af
<a href='kapitel13.jsp'>kapitel 13</a>, H&aelig;ndelser.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;tter
<a href='kapitel9.jsp'>kapitel 9</a>, Grafiske programmer, og at du har adgang til et v&aelig;rkt&oslash;j,
der kan udvikle grafiske brugergr&aelig;nseflader (f.eks. Borland
JBuilder, Oracle JDeveloper, Netbeans eller Eclipse). 
</P>

<P LANG="da-DK" CLASS="western" STYLE="">N&aring;r
man skal lave en grafisk brugergr&aelig;nseflade (eng.: GUI,
graphical user interface), g&oslash;res det oftest ved at anvende
standardkomponenter. Vi vil starte med at se p&aring;, hvordan
det g&oslash;res i praksis med et v&aelig;rkt&oslash;j, og derefter
studere den kode, der kommer ud af det.</P>
<H2 CLASS="western">11.1 <a name='afsn11.1'></a>Generering med et v&aelig;rkt&oslash;j</SPAN></H2>
<P LANG="da-DK" CLASS="western">Med moderne udviklingsv&aelig;rkt&oslash;jer
kan man udarbejde en grafisk brugergr&aelig;nseflade ud fra
standardkomponenter p&aring; ret kort tid og uden at skulle
programmere ret meget selv.</P>
<P LANG="da-DK" CLASS="western">Herunder er beskrevet, hvordan man
g&oslash;r i JBuilder 2006 med sidel&oslash;bende forklaringer til
udviklingsv&aelig;rkt&oslash;jerne Oracle JDeveloper og Netbeans.
Bruger du et andet v&aelig;rkt&oslash;j (herunder JBuilder
2007), m&aring; du pr&oslash;ve dig lidt frem. Ideerne er de samme og
koden, der genereres, ligner ogs&aring; nogenlunde, men menuerne og
knapperne varierer selvf&oslash;lgelig noget.</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_mce1c20b.gif" ALIGN=MIDDLE></P>
<P LANG="da-DK" CLASS="western">I JBuilder 2006/JDeveloper er det
muligt at tage en eksisterende klasse, der arver fra JPanel eller
JApplet f.eks. Grafikpanel fra <a href='kapitel9.jsp'>kapitel 9</a>. Hvis du vil oprette en ny,
s&aring; v&aelig;lg 'New...' og Application eller Applet. Skriv et
navn p&aring; din klasse og klik 'Finish'. Tegn evt. noget i
paintComponent(). 
</P>
<P LANG="da-DK" CLASS="western">I Netbeans skal du under 'New File..'
v&aelig;lge 'Java GUI Forms' og 'JPanel Form'. Se evt.:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/learn/index.html">http://java.sun.com/docs/books/tutorial/uiswing/learn/index.html</A>.
I andre v&aelig;rkt&oslash;jer: Opret en ny JApplet eller JPanel
(bruger du JPanel skal du ogs&aring; huske en Benyt...-klasse).</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western">G&aring; over p&aring;
  Design-fanen (ved punkt 1 nederst). Den er delt op i en del, hvor du
  designer din brugergr&aelig;nseflade i midten og en tabel af
  egenskaber til h&oslash;jre (punkt 2).<BR>JDeveloper: H&oslash;jreklik
  p&aring; Grafikpanel.java og v&aelig;lg 'UI Editor'.<BR>Netbeans: G&aring;
  over p&aring; fanen 'GUI Editing', hvis du ikke allerede st&aring;r
  der.</P>
  <LI><P LANG="da-DK" CLASS="western">Her skal du f&oslash;rst &aelig;ndre
  layout fra '&lt;default layout&gt;' til 'null' (punkt 2 til h&oslash;jre;
  m&aring;ske skal du klikke p&aring; den gr&aring; flade i designeren
  f&oslash;rst).<BR>Netbeans: H&oslash;jreklik p&aring; den gr&aring;
  flade og v&aelig;lg 'Set Layout' og 'Null layout'.</P>
  <LI><P LANG="da-DK" CLASS="western">Nu kan du g&aring; i gang med at
  l&aelig;gge komponenter ind p&aring; gr&aelig;nsefladen. <BR>V&aelig;lg
  f&oslash;rst en JLabel fra komponentpaletten (punkt 3) og klik p&aring;
  den gr&aring; flade. Der dukker en etikette med en tekst op. P&aring;
  egenskabstabellen til h&oslash;jre kan du &aelig;ndre dens
  variabelnavn (<I><SPAN STYLE="font-weight: medium">name</SPAN></I>
  &oslash;verst) til f.eks. labelHvadErDitNavn. L&aelig;ngere nede er
  egenskaben <I><SPAN STYLE="font-weight: medium">text</SPAN></I>, der
  bestemmer, hvad der skal st&aring; p&aring; etiketten. Ret den til
  f.eks. &quot;Hvad er dit navn?&quot;.</P>
  <LI><P LANG="da-DK" CLASS="western">Inds&aelig;t derefter et
  JTextField (et indtastningsfelt – lidt l&aelig;ngere nede i
  listen). <BR>Ret variabelnavnet til textFieldNavn og teksten til
  f.eks. &quot;Jacob&quot;.</P>
</OL>
<P LANG="da-DK" CLASS="western">G&aring; tilbage til Source-fanen. Nu
ser kildeteksten nogenlunde s&aring;ledes ud:</P>
<PRE CLASS="ikke-javakode-western">import java.awt.*;
import javax.swing.*;

public class Grafikpanel extends JPanel
{
  <B>JLabel labelHvadErDitNavn = new JLabel()</B>;
  <B>JTextField textFieldNavn = new JTextField()</B>;

  public void paintComponent(Graphics g)
  {
    super.paintComponent(g);              <I>// tegn f&oslash;rst baggrunden p&aring; panelet</I>
    g.drawLine(0,0,50,50);
    g.fillOval(5,10,300,30);
    g.setColor(Color.GREEN);
    g.drawString(&quot;Hej grafiske verden!&quot;,100,30);
  }

  public Grafikpanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    <B>labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;)</B>;
    labelHvadErDitNavn.setBounds(new Rectangle(15, 69, 108, 15));
    <B>textFieldNavn.setText(&quot;Jacob&quot;)</B>;
    textFieldNavn.setBounds(new Rectangle(141, 61, 112, 29));
    this.setLayout(null);
    this.add(textFieldNavn);
    this.add(labelHvadErDitNavn);
  }
}</PRE><P LANG="da-DK" CLASS="western">
De to objekter, vi satte p&aring; i designeren, er erkl&aelig;ret og
oprettet &oslash;verst uden for metoderne:</P>
<PRE CLASS="kode-western">  JLabel labelHvadErDitNavn = new JLabel();
  JTextField textFieldNavn = new JTextField();</PRE><P LANG="da-DK" CLASS="western">
Nedenunder st&aring;r vores gamle paintComponent() u&aelig;ndret.
Herunder er der oprettet en konstrukt&oslash;r, der kalder metoden
jbInit() (i Netbeans hedder metoden initComponents()). 
</P>
<P LANG="da-DK" CLASS="western">Den andet kode, 'try{ ... } catch
(Exception e) {...}' er beregnet til at h&aring;ndtere undtagelser og
vil blive forklaret i <a href='kapitel14.jsp'>kapitel 14</a>, Undtagelser. Se bort fra den for
nu.</P>
<P LANG="da-DK" CLASS="western">I metoden jbInit() nedenunder l&aelig;gger
v&aelig;rkt&oslash;jet koden til at initialisere de grafiske
komponenter. Man ser her, hvordan b&aring;de JLabel og JTextField har
metoden setText() og at begge objekter f&aring;r kaldt denne metode
(svarende til, at vi &aelig;ndrede egenskaben <I><SPAN STYLE="font-weight: medium">text</SPAN></I>).</P>
<PRE CLASS="kode-western">    labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;);
    textFieldNavn.setText(&quot;Jacob&quot;);</PRE><P LANG="da-DK" CLASS="western">
De andre kommandoer i jbInit() s&oslash;rger for at placere
komponenterne korrekt i vinduet.</P>
<P LANG="da-DK" CLASS="western">&quot;Design&quot;- og &quot;Source&quot;-fanen
er to m&aring;der at se programmet p&aring; og man kan frit skifte
mellem dem. Laver man en design&aelig;ndring, vil det blive afspejlet
i koden i jbInit(). &AElig;ndrer man i koden, vil designet &aelig;ndre
sig (i Netbeans er kildekoden dog beskyttet mod &aelig;ndringer). 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Retter du eller
tilf&oslash;jer kode til v&aelig;rkt&oslash;jets genererede kode (i
jbInit()), s&aring; s&oslash;rg for, at det ligner v&aelig;rkt&oslash;jets
egen kode, ellers kan v&aelig;rkt&oslash;jet have sv&aelig;rt ved at
opretholde sammenh&aelig;ngen mellem kode og design.</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Anden kode kan du putte i
konstrukt&oslash;ren, f.eks. lige over eller under kaldet til
jbInit().</P>


<H3 CLASS="western">11.1.1 <a name='afsn11.1.1'></a>Interaktive programmer</H3>
<P LANG="da-DK" CLASS="western">Lad os nu tilf&oslash;je en knap og
et indtastningsfelt p&aring; flere linjer (JTextArea). Jeg kalder dem
for buttonOpdater og textAreaHilsen. Knappen skal selvf&oslash;lgelig
g&oslash;re noget. Fra Design-fanen, dobbeltklik p&aring; knappen, og
vupti! Der genereres automatisk en metode til at h&aring;ndtere
et klik (og pakken java.awt.event bliver importeret):</P>
<PRE CLASS="kode-western">  void buttonOpdater_actionPerformed(ActionEvent e) {

  }</PRE><P LANG="da-DK" CLASS="western">
Hvis du kigger i jbInit(), kan du se, at JBuilder har indsat f&oslash;lgende
kode:</P>
<PRE CLASS="kode-western">    buttonOpdater.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        buttonOpdater_actionPerformed(e);
      }
    });</PRE><P LANG="da-DK" CLASS="western">
Det er disse linjer, der s&oslash;rger for at &quot;lytte efter
h&aelig;ndelser&quot; p&aring; knappen, s&aring;dan at n&aring;r man
klikker p&aring; buttonOpdater, s&aring; kaldes metoden
buttonOpdater_actionPerformed(). Det vil vi komme tilbage til i
<a href='kapitel13.jsp'>kapitel 13</a>, H&aelig;ndelser.</P>
<P LANG="da-DK" CLASS="western">Nu kan du inds&aelig;tte kode, der
udf&oslash;rer en handling. Skriv f.eks. noget ud til systemoutput: 
</P>
<PRE CLASS="kode-western">  void buttonOpdater_actionPerformed(ActionEvent e) {
    System.out.println(&quot;Opdater!&quot;);
  }</PRE><P LANG="da-DK" CLASS="western">
Vi kunne ogs&aring; lave noget sjovere, f.eks. l&aelig;se den
indtastede tekst fra textFieldNavn og skrive den i textAreaHilsen.
JBuilder har lavet koden, der s&aelig;tter teksterne for os og ved at
studere den kan man f&aring; en ide til, hvordan det skal g&oslash;res:</P>
<PRE CLASS="kode-western">    String navn = textFieldNavn.getText();     // afl&aelig;s navnet

    textAreaHilsen.setText(&quot;Hej k&aelig;re &quot;+navn);  // s&aelig;t navnet</PRE>
<P LANG="da-DK" CLASS="western">Her har vi tastet &quot;Jacob
Nordfalk&quot; ind og trykket p&aring; &quot;opdater!&quot;-knappen
(paintComponent() er &aelig;ndret til ogs&aring; at tegne navnet 5
gange).</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_1aa934a1.png" NAME="grafik10" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Her kommer det fulde eksempel med en
main-metode, der viser vinduet.</P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytGrafikpanelMedKomponenter
{
  public static void main(String[] arg)
  {
    JFrame vindue = new JFrame( &quot;GrafikpanelMedKomponenter&quot; ); 
    vindue.add( new GrafikpanelMedKomponenter() );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
    vindue.setSize(350,300);
    vindue.setVisible(true);
  }
}</PRE>
<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class GrafikpanelMedKomponenter extends JPanel
{
  JLabel labelHvadErDitNavn = new JLabel();
  JTextField textFieldNavn = new JTextField();
<B>  JButton buttonOpdater = new JButton();</B>
<B>  JTextArea textAreaHilsen = new JTextArea();</B>

  public void paintComponent(Graphics g)
  {
    super.paintComponent(g);     <I>// tegn baggrunden p&aring; panelet</I>
    g.drawLine(0,0,50,50);
    g.fillOval(5,10,300,30);
    g.setColor(Color.GREEN);
    String navn = textFieldNavn.getText();
    for (int i=0; i&lt;50; i=i+10)
      g.drawString(&quot;Hej &quot;+navn+&quot; !&quot;,100+i,30+i);
  }

  public GrafikpanelMedKomponenter() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

<I>  /** Udviklingsv&aelig;rkt&oslash;jets initialisering af komponenter.</I>
<I>   *  Udviklingsv&aelig;rkt&oslash;j definerer gerne en separat metode hvor de </I>
<I>   *  initialiserer komponenterne. I JBuilder og JDeveloper hedder</I>
<I>   *  den jbInit(), mens den hedder initComponents() i Betbeans.</I>
<I>   *  Initialiseringen kunne dog lige s&aring; godt ligge direkte i konstrukt&oslash;ren.</I>
<I>   *  &AElig;ndr med varsomhed, ellers kan v&aelig;rkt&oslash;jet ikke genkende &quot;sin&quot; kode!</I>
<I>   */</I>
  private void jbInit() throws Exception {
    labelHvadErDitNavn.setText(&quot;Hvad er dit navn?&quot;);
    labelHvadErDitNavn.setBounds(new Rectangle(15, 69, 108, 15));
    textFieldNavn.setText(&quot;Jacob&quot;);
    textFieldNavn.setBounds(new Rectangle(129, 61, 95, 29));
<B>    buttonOpdater.setText(&quot;Opdater!&quot;);</B>
    buttonOpdater.setMnemonic(KeyEvent.VK_O);
    buttonOpdater.setBounds(new Rectangle(231, 60, 91, 32));
    buttonOpdater.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        buttonOpdater_actionPerformed(e);
      }
    });
<B>    textAreaHilsen.setText(&quot;Her kommer en tekst...&quot;);</B>
    textAreaHilsen.setBounds(new Rectangle(6, 102, 316, 78));
    this.setLayout(null);
    this.add(labelHvadErDitNavn);
    this.add(textAreaHilsen);
    this.add(buttonOpdater);
    this.add(textFieldNavn);
  }

  void buttonOpdater_actionPerformed(ActionEvent e) {
<B>    String navn = textFieldNavn.getText();</B>
    System.out.println(&quot;Opdater! navn=&quot;+navn);
<B>    textAreaHilsen.setText(&quot;Hej k&aelig;re &quot;+navn);</B>
<B>    repaint();</B><I><SPAN STYLE="font-weight: medium"> // gentegn vinduet</SPAN></I>
  }
}</PRE><H3 CLASS="western">
11.1.2 <a name='afsn11.1.2'></a>Genvejstaster</H3>
<P LANG="da-DK" CLASS="western">Genvejstaster kan laves p&aring; de
fleste komponenter med kaldet setMnemonic(). I ovenst&aring;ende
eksempel kan man trykke Alt-O for at trykke p&aring;
'Opdater'-knappen, fordi vi kaldte:</P>
<PRE CLASS="kode-western">    buttonOpdater.setMnemonic(KeyEvent.VK_O);</PRE>
<H2 CLASS="western">11.2 <a name='afsn11.2'></a>Overblik over komponenter</SPAN></H2>
<P LANG="da-DK" CLASS="western">Grafiske komponenter er objekter, der
bruges som en synlig del af en grafisk brugergr&aelig;nseflade,
f.eks. knapper, valglister, indtastningsfelter, etiketter.</P>
<P LANG="da-DK" CLASS="western">Alle komponenter arver fra
JComponent-klassen og har derfor dennes tr&aelig;k til f&aelig;lles:</P>
<P LANG="da-DK" CLASS="western">Metoderne setForeground(Color c) og
setBackground(Color c) s&aelig;tter hhv. forgrundsfarven og
baggrundsfarven for komponenten, svarende til egenskaberne <I>foreground</I>
og <I>background</I>. Egenskaberne kan afl&aelig;ses med
getForeground() og getBackground().</P>
<P LANG="da-DK" CLASS="western">En anden egenskab er <I>font</I>, der
bestemmer skrifttypen. I tr&aring;d med de andre egenskaber s&aelig;ttes
den med setFont(Font f) og afl&aelig;ses med getFont().</P>
<P LANG="da-DK" CLASS="western">Dette kan sammenfattes i en tabel
over egenskaber, der er f&aelig;lles for alle komponenter.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">foreground</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">Color</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setForeground(Color c)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getForeground()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">background</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">Color</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setBackground(Color c)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getBackground()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">font</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">Font</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setFont(Font f)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getFont()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">visible</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setVisible(boolean synlig)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">isVisible()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">Nedenfor er de mest almindelige
komponenter beskrevet sammen med deres egenskaber.</P>

<H3 CLASS="western">11.2.1 <a name='afsn11.2.1'></a><IMG SRC="bog12_html_m428107b9.png" NAME="grafik3" ALIGN=LEFT BORDER=0>JLabel</H3>
<P LANG="da-DK" CLASS="western">En etiket, der viser en tekst (som
brugeren ikke kan redigere i). 
</P>
<P LANG="da-DK" CLASS="western">Udover de f&aelig;lles egenskaber
findes egenskaben <I>text</I>, der angiver, hvad der st&aring;r i
feltet. 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">text</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">String</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">GetText()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">Mere info:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/components/label.html">http://java.sun.com/docs/books/tutorial/uiswing/components/label.html</A>
</P>

<H3 CLASS="western">11.2.2 <a name='afsn11.2.2'></a><IMG SRC="bog12_html_m55f34bba.png" NAME="grafik4" ALIGN=LEFT BORDER=0>JButton</H3>
<P LANG="da-DK" CLASS="western">En trykknap. Egenskaben <I>text</I>
angiver, hvad der st&aring;r p&aring; knappen.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">text</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">String</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getText()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<H3 CLASS="western">11.2.3 <a name='afsn11.2.3'></a>JCheckBox og JRadioButton</H3>
<P LANG="da-DK" CLASS="western"><IMG SRC="bog12_html_8d91411.png" NAME="grafik5" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>JCheckBox
giver et afkrydsningsfelt, som brugeren kan s&aelig;tte et flueben i
(eller fjerne).</P>
<P LANG="da-DK" CLASS="western">JRadioButton bruges til radioknapper,
der gensidigt udelukker hinanden. En gruppe af radioknapper skal
knyttes sammen af et ButtonGroup-objekt (se eksemplet senere).</P>
<P LANG="da-DK" CLASS="western"><I>text</I> angiver, hvad der st&aring;r
ved feltet. <I>selected</I> angiver, om feltet/radioknappen er
afkrydset.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">text</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">String</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getText()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">selected</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setSelected (boolean afkrydset)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">isSelected()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<H3 CLASS="western">11.2.4 <a name='afsn11.2.4'></a><IMG SRC="bog12_html_m2c9bf387.png" NAME="grafik6" ALIGN=LEFT BORDER=0>JTextField</H3>
<P LANG="da-DK" CLASS="western">Et indtastningsfelt p&aring; &eacute;n
linje. Egenskaben <I>text</I> angiver, hvad der st&aring;r i feltet. 
</P>
<P LANG="da-DK" CLASS="western"><I>columns</I> angiver, hvor bredt
feltet skal v&aelig;re.</P>
<P LANG="da-DK" CLASS="western"><I>editable</I> angiver, om brugeren
kan redigere teksten i indtastningsfeltet.</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">text</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">String</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getText()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">editable</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setEditable(boolean rediger)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">isEditable()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">columns</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">int</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setColumns(int bredde)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getColumns()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>

<H3 CLASS="western">11.2.5 <a name='afsn11.2.5'></a>JTextArea</H3>
<P LANG="da-DK" CLASS="western"><IMG SRC="bog12_html_129fa156.png" NAME="grafik7" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>Et
indtastningsfelt p&aring; flere linjer.</P>
<P LANG="da-DK" CLASS="western">Egenskaberne <I>text, rows</I><SPAN STYLE="font-style: normal">
og </SPAN><I>columns</I> angiver, hvad der st&aring;r i feltet, hhv.
bredde og h&oslash;jde. 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">text</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">String</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setText(String t)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getText()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">editable</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setEditable(boolean rediger)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">isEditable()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">columns</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">int</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setColumns(int bredde)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getColumns()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">rows</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">int</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setRows(int h&oslash;jde)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getRows()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">JTextField og JTextArea har en del
egenskaber til f&aelig;lles og disse f&aelig;llestr&aelig;k ligger i
superklassen JTextComponent, der ogs&aring; har andre arvinger,
s&aring;som JPasswordField og JTextPane (der tillader redigering
tekst med typografier, s&aring;som HTML og RTF). L&aelig;s mere om
disse p&aring;:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/components/text.html">http://java.sun.com/docs/books/tutorial/uiswing/components/text.html</A>
</P>

<H3 CLASS="western">11.2.6 <a name='afsn11.2.6'></a><IMG SRC="bog12_html_m305a184a.png" NAME="grafik8" ALIGN=LEFT BORDER=0>JComboBox</H3>
<P LANG="da-DK" CLASS="western">En valgliste. Det er nemmest at bruge
metoden addItem(String elementnavn) til at tilf&oslash;je indgange,
men der er ogs&aring; bl.a. mulighed for at give et array af
elementer i konstrukt&oslash;ren.</P>
<PRE CLASS="kode-western">  JComboBox comboBox1 = new JComboBox();
...
    comboBox1.addItem(&quot;ComboBox R&oslash;d&quot;);
    comboBox1.addItem(&quot;ComboBox Gr&oslash;n&quot;);
    comboBox1.addItem(&quot;ComboBox Bl&aring;&quot;);</PRE><P LANG="da-DK" CLASS="western">
Med getSelectedItem() unders&oslash;ger man, hvad brugeren har valgt.
Hvis man foretr&aelig;kker at kende nummeret p&aring; det valgte
element, bruger man getSelectedIndex().</P>
<P LANG="da-DK" CLASS="western">Se ogs&aring;:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/components/combobox.html">http://java.sun.com/docs/books/tutorial/uiswing/components/combobox.html</A>
</P>

<P LANG="da-DK" CLASS="western" STYLE=""><IMG SRC="bog12_html_2f899d12.png" NAME="grafik9" ALIGN=LEFT BORDER=0><BR><BR>
</P>
<H3 CLASS="western">11.2.7 <a name='afsn11.2.7'></a>JList</H3>

<P LANG="da-DK" CLASS="western">En liste, hvor flere af indgangene
kan ses samtidigt og hvor man kan v&aelig;lge en eller flere
elementer. Desv&aelig;rre er komponenten lidt sv&aelig;r at bruge for
begyndere; det nemmeste er at oprette et array af elementer og
overf&oslash;re arrayet i konstrukt&oslash;ren:</P>
<PRE CLASS="kode-western">  String[] listedata = {&quot;List r&oslash;d&quot;, &quot;List gr&oslash;n&quot;, &quot;List bl&aring;&quot;};
  JList list1 = new JList(listedata);</PRE><P LANG="da-DK" CLASS="western">
Med getSelectedValue() unders&oslash;ger man, hvad brugeren har
valgt. Hvis man foretr&aelig;kker at kende nummeret p&aring; det
valgte element bruger man getSelectedIndex().</P>
<P LANG="da-DK" CLASS="western">Egenskaberne <I>rows</I><SPAN STYLE="font-style: normal">
og </SPAN><I>multipleMode</I> angiver hhv. hvor mange indgange, der
kan ses ad gangen og om man kan v&aelig;lge flere indgange samtidigt
(ved at holde Ctrl nede og klikke). 
</P>
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>
  <COL*>
  <COL*>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TH>
        <P LANG="da-DK" CLASS="western">Egenskab</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">Type</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">S&aelig;ttes med</P>
      </TH>
      <TH>
        <P LANG="da-DK" CLASS="western">L&aelig;ses med</P>
      </TH>
    </TR>
  </THEAD>
  <TBODY>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">rows</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">int</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setRows(int h&oslash;jde)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getRows()</P>
      </TD>
    </TR>
    <TR VALIGN=TOP>
      <TD>
        <P LANG="da-DK" CLASS="western">multipleMode</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">boolean</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">setMultipleMode(boolean m)</P>
      </TD>
      <TD>
        <P LANG="da-DK" CLASS="western">getMultipleMode()</P>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<P LANG="da-DK" CLASS="western">Er <I>multipleMode</I> sl&aring;et
til, kan man l&oslash;be gennem antallet af indgange og for hver
indgang bruge isIndexSelected(int indeks) til at se, om indgangen er
valgt.</P>

<H2 CLASS="western">11.3 <a name='afsn11.3'></a>Eksempel</SPAN></H2>
<P LANG="da-DK" CLASS="western">Herunder et eksempel (genereret med
JBuilder) med komponenterne omtalt i forrige afsnit. 
</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_m4351b4ed.png" NAME="grafik2" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytOverblikOverKomponenter
{
  public static void main(String[] arg)
  {
    JFrame vindue = new JFrame( &quot;OverblikOverKomponenter&quot; ); 
    vindue.add( new OverblikOverKomponenter() );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
    vindue.setSize(500,150);
    vindue.setVisible(true);
  }
}</PRE>
<PRE CLASS="kode-western">import java.awt.*;
import javax.swing.*;

public class OverblikOverKomponenter extends JPanel
{
<I>  // opret alle komponenterne og husk dem i nogle objektvariabler</I>
  JLabel label1 = new JLabel();
  JButton button1 = new JButton();
  JCheckBox checkbox1 = new JCheckBox();
  JCheckBox checkbox2 = new JCheckBox();
  JCheckBox checkbox3 = new JCheckBox();
  JRadioButton radio1 = new JRadioButton();
  JRadioButton radio2 = new JRadioButton();
  ButtonGroup buttonGroup1 = new ButtonGroup();
  JTextField textField1 = new JTextField();
  JTextArea textArea1 = new JTextArea();
  JComboBox comboBox1 = new JComboBox();

  String[] listedata = {&quot;List r&oslash;d&quot;, &quot;List gr&oslash;n&quot;, &quot;List bl&aring;&quot;};
  JList list1 = new JList(listedata);

  FlowLayout flowLayout1 = new FlowLayout(); <I>// layout-manager (se senere)</I>

  public OverblikOverKomponenter() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    label1.setText(&quot;En Label&quot;);

    button1.setText(&quot;OK&quot;);

    checkbox1.setText(&quot;En&quot;);    <I>// s&aelig;t afkrydsningsfelternes navne</I>
    checkbox2.setText(&quot;To&quot;);
    checkbox3.setText(&quot;Tre&quot;);

    radio1.setText(&quot;Radio1&quot;);   <I>// s&aelig;t radioknappernes navne og</I>
    radio2.setText(&quot;Radio2&quot;);
    buttonGroup1.add(radio1);   <I>// gruppe - s&aring; de gensidigt udelukker hinanden</I>
    buttonGroup1.add(radio2);
    radio1.setSelected(true);

    comboBox1.addItem(&quot;ComboBox R&oslash;d&quot;);
    comboBox1.addItem(&quot;ComboBox Gr&oslash;n&quot;);
    comboBox1.addItem(&quot;ComboBox Bl&aring;&quot;);

    textField1.setColumns(10);
    textField1.setText(&quot;Et TextField&quot;);

    textArea1.setColumns(15);
    textArea1.setRows(5);
    textArea1.setText(&quot;Et TextArea&quot;);

    this.setLayout(flowLayout1);<I>// s&aelig;t layout-manager (se senere)</I>

    this.add(label1);     <I>// til sidst skal komponenterne f&oslash;jes</I>
    this.add(button1);    <I>// til containeren (se senere)</I>
    this.add(checkbox1);
    this.add(checkbox2);
    this.add(checkbox3);
    this.add(radio1);
    this.add(radio2);
    this.add(textField1);
    this.add(textArea1);
    this.add(comboBox1);
    this.add(list1);
  }
}</PRE>
<H2 CLASS="western">11.4 <a name='afsn11.4'></a>Overblik over containere</SPAN></H2>
<P LANG="da-DK" CLASS="western">En <I>container</I> er beregnet til
at indeholde komponenter og styre, hvordan de vises p&aring; sk&aelig;rmen.
Alle containere har en s&aring;kaldt <I>layout-manager</I><SPAN STYLE="font-style: normal">
tilknyttet, der hj&aelig;lper containeren med at afg&oslash;re, hvor
og med hvilken st&oslash;rrelse komponenterne skal vises.</SPAN>
</P>
<P LANG="da-DK" CLASS="western">For at en komponent bliver vist, skal
den tilf&oslash;jes en container. I eksemplet ovenfor er panelet den
container, komponenterne bliver tilf&oslash;jet og derfor st&aring;r
der sidst i initialiseringen:</P>
<PRE CLASS="kode-western">    this.add(button1);</PRE><H3 CLASS="western" ALIGN=LEFT>
11.4.1 <a name='afsn11.4.1'></a>JWindow</H3>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>JWindow repr&aelig;senterer
et bart vindue uden en titellinje eller lukkeknap &oslash;verst. Det
bruges meget sj&aelig;ldent direkte. Man bruger i stedet arvingerne
JFrame og JDialog.</P>
<H3 CLASS="western">11.4.2 <a name='afsn11.4.2'></a>JDialog</H3>
<P LANG="da-DK" CLASS="western">Dialog bruges til dialog-bokse,
vinduer, der dukker op med et eller andet sp&oslash;rgsm&aring;l, som
skal besvares, f&oslash;r man kan g&aring; videre. Egenskaben <I>modal</I>
angiver, om dialog-boksen er modal, dvs. om man skal lukke den, f&oslash;r
man kan f&aring; adgang til ejer-vinduet. Den s&aelig;ttes med
setModal(boolean m) og afl&aelig;ses med isModal(). Hvis vinduet er
modalt vil et kald til setVisible(true) vente, indtil brugeren har
udfyldt og lukket dialog-boksen igen.</P>
<P LANG="da-DK" CLASS="western">I mange tilf&aelig;lde vil
JOptionPane, der er beskrevet i <a href='kapitel2.jsp#afsn2.12.1'>afsnit 2.12.1</a>, v&aelig;re nemmere at
bruge. S&aring;ledes kunne man f.eks. vise panelet
OverblikOverKomponenter i en dialog med koden:</P>
<PRE CLASS="kode-western" STYLE="text-align: left">import javax.swing.*;
public class DialogMedOverblikOverKomponenter
{
  public static void main(String[] arg)
  {
    JOptionPane.showMessageDialog(null,new OverblikOverKomponenter());
  }
}</PRE><P LANG="da-DK" CLASS="western">
<IMG SRC="bog12_html_5b43d9ec.png" NAME="grafik11" ALIGN=BOTTOM BORDER=0></P>
<H3 CLASS="western" ALIGN=LEFT>11.4.3 <a name='afsn11.4.3'></a>JFrame</H3>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>En JFrame er den simpleste
og oftest brugte m&aring;de at definere et &quot;normalt&quot; vindue
med titel, luk-knap, minim&eacute;r-knap etc. Den er brugt i n&aelig;sten
alle eksempler i denne bog.</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.4 <a name='afsn11.4.4'></a>JPanel</H3>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>Et panel er den simpleste
og oftest brugte container. Den indeholder simpelthen komponenterne
(i henhold til layout-manageren). JPanel er samtidig ogs&aring; en
komponent, dvs. man kan tilf&oslash;je den til enhver anden container
(et vindue eller endda til et andet JPanel).</P>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>Kan ens vindue opdeles i
flere logiske dele (f.eks. har JBuilder i <a href='kapitel11.jsp#afsn11.1'>afsnit 11.1</a> en
komponentpalette, designvindue og egenskabstabel) er det god praksis
at l&aelig;gge disse i hver sit panel.</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.5 <a name='afsn11.4.5'></a>JApplet</H3>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>En applet er et panel, der
er beregnet til at blive vist i en netl&aelig;ser. Se <a href='kapitel10.jsp'>kapitel 10</a>, Appletter.</P>
<H3 CLASS="western" ALIGN=LEFT>11.4.6 <a name='afsn11.4.6'></a>JTabbedPane</H3>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT>Et panel, der viser et s&aelig;t
af faneblade, der hver kan indeholde &eacute;n komponent – som
n&aelig;sten altid er et et JPanel. Herunder viser vi alle
eksemplerne fra dette kapitel i hver sit faneblad:</P>
<P LANG="da-DK" CLASS="western" ALIGN=LEFT><IMG SRC="bog12_html_m2907d260.png" NAME="grafik15" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT><BR><BR>
</P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytFaneblade
{
  public static void main(String[] arg)
  {
<B>    JTabbedPane faneblade = new JTabbedPane();</B>

    <B>faneblade.add(</B>&quot;GrafikpanelMedKomponenter&quot;, <B>new GrafikpanelMedKomponenter());</B>
<B>    faneblade.add(</B>&quot;OverblikOverKomponenter&quot;, <B>new OverblikOverKomponenter());</B>
<B>    faneblade.add(</B>&quot;PanelMedBorderLayout&quot;, <B>new PanelMedBorderLayout());</B>
<B>    faneblade.add(</B>&quot;PanelMedGridBagLayout&quot;, <B>new PanelMedGridBagLayout());</B>

    JFrame vindue = new JFrame(&quot;Faneblade&quot;);
    vindue.add( faneblade );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); <I>// reag&eacute;r p&aring; luk</I>
    vindue.pack();                  <I>// lad vinduet selv bestemme sin st&oslash;rrelse</I>
    vindue.setVisible(true);                                  <I>// &aring;bn vinduet</I>

  }
}</PRE><H2 CLASS="western">
11.5 <a name='afsn11.5'></a>Layout-managere</SPAN></H2>
<P LANG="da-DK" CLASS="western">En layout-manager styrer layoutet af
komponenterne p&aring; et JPanel eller en anden container. Alle
containere har egenskaben <I>layout</I>, der kan s&aelig;ttes med
metoden setLayout(Layout l).</P>
<P LANG="da-DK" CLASS="western">For mere info, se:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/layout/">http://java.sun.com/docs/books/tutorial/uiswing/layout/</A></P>
<H3 CLASS="western">11.5.1 <a name='afsn11.5.1'></a>Ingen styring (null-layout)</H3>
<P LANG="da-DK" CLASS="western">I udviklingsfasen er det mest bekvemt
at s&aelig;tte layout-manageren til null. Dette tillader udvikleren
at s&aelig;tte komponenterne, som han vil p&aring; en hvilken som
helst (x,y)-position og med en hvilken som helst h&oslash;jde og
bredde. Koden ser s&aring;ledes ud:</P>
<PRE CLASS="kode-western">    this.setLayout(null);                              <I>// s&aelig;t null-layout</I>
    this.add(button1);                                 <I>// tilf&oslash;j knap</I>
    button1.setBounds(new Rectangle(231, 60, 91, 32)); <I>// s&aelig;t position/st&oslash;rrelse</I></PRE><P LANG="da-DK" CLASS="western">
null-layout tager slet ikke h&oslash;jde for vinduets st&oslash;rrelse,
s&aring; hvis vinduet bliver for lille, vil nogle af komponenterne
ikke blive vist. N&aring;r programmet er ved at v&aelig;re f&aelig;rdigt,
b&oslash;r man derfor &aelig;ndre programmet til at bruge en
layout-manager, der kan styre komponenternes st&oslash;rrelse og
indbyrdes placering ud fra deres behov.</P>
<H3 CLASS="western">11.5.2 <a name='afsn11.5.2'></a>FlowLayout</H3>
<P LANG="da-DK" CLASS="western">FlowLayout placerer komponenterne
ligesom tekst, der er centreret: &Oslash;verst fra venstre mod h&oslash;jre
og p&aring; en ny linje nedenunder, n&aring;r der ikke er mere plads.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog12_html_4a250352.png" NAME="Grafik7" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">I eksemplet OverblikOverKomponenter
ovenfor blev FlowLayout brugt (egentligt var det overfl&oslash;digt
at angive, for angiver man ikke nogen layout-manager i et
panel/applet, vil FlowLayout blive brugt automatisk).</P>
<H3 CLASS="western">11.5.3 <a name='afsn11.5.3'></a>BorderLayout</H3>
<P LANG="da-DK" CLASS="western">BorderLayout tager h&oslash;jde for
vinduets st&oslash;rrelse og tilpasser komponenternes st&oslash;rrelse
efter den tilg&aelig;ngelige plads. Komponenterne kan placeres
p&aring; 5 mulige positioner, nemlig NORTH, SOUTH, EAST, WEST og
CENTER.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog12_html_7b029000.png" NAME="Grafik10" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Den mest almindelige m&aring;de at
lave det grafiske layout af et sk&aelig;rmbillede er med
BorderLayout. I de omr&aring;der, hvor man &oslash;nsker at
placere flere komponenter, s&aelig;tter man f&oslash;rst et JPanel og
komponenterne tilf&oslash;jes s&aring; panelet.</P>
<P LANG="da-DK" CLASS="western">Angiver man ikke nogen layout-manager
i et vindue, vil BorderLayout blive brugt (i eksemplet nedenfor kunne
de to linjer omkring BorderLayout strengt taget fjernes).</P>
<PRE CLASS="kode-western" STYLE="text-align: left">import java.awt.*;
import javax.swing.*;

public class PanelMedBorderLayout extends JPanel
{
  JButton button1 = new JButton();
  JButton button2 = new JButton();
  JButton button3 = new JButton();
  JButton button4 = new JButton();
  JButton button5 = new JButton();

  <B>BorderLayout borderLayout1 = new BorderLayout();</B>

  public PanelMedBorderLayout() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    button1.setText(&quot;NORTH&quot;);
    button2.setText(&quot;SOUTH&quot;);
    button3.setText(&quot;EAST&quot;);
    button4.setText(&quot;WEST&quot;);
    button5.setText(&quot;CENTER&quot;);

<B>    this.setLayout(borderLayout1);</B>

<B>    this.add(button1, BorderLayout.NORTH);</B>
<B>    this.add(button2, BorderLayout.SOUTH);</B>
<B>    this.add(button3, BorderLayout.EAST);</B>
<B>    this.add(button4, BorderLayout.WEST);</B>
<B>    this.add(button5, BorderLayout.CENTER);</B>
  }
}</PRE><P LANG="da-DK" CLASS="western" ALIGN=LEFT>
Man s&aelig;tter alts&aring; f&oslash;rst layoutet ved at kalde
setLayout() med et BorderLayout-objekt. Derefter kan add() kaldes med
komponenterne og deres placering p&aring; borderlayoutet.</P>
<P LANG="da-DK" CLASS="western">Bem&aelig;rk, at n&aring;r man bruger
en layout-manager, b&oslash;r man lade den afg&oslash;re vinduets
st&oslash;rrelse ud fra komponenternes behov, ved at kalde pack() i
stedet for setSize() p&aring; vinduet. Denne metode pakker
komponenterne i vinduet optimalt og s&aelig;tter vinduesst&oslash;rrelsen
passende.</P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytPanelMedBorderLayout
{
  public static void main(String[] arg)
  {
    JFrame vindue = new JFrame( &quot;PanelMedBorderLayout&quot; ); 
    vindue.add( new PanelMedBorderLayout() );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
    <B>vindue.pack()</B>;<I>// s&aelig;tter en rimelig vinduesst&oslash;rrelse (i stedet for setSize())</I>
    vindue.setVisible(true);
  }
}</PRE><H3 CLASS="western">
11.5.4 <a name='afsn11.5.4'></a>GridBagLayout</H3>
<P LANG="da-DK" CLASS="western">En anden m&aring;de at lave layout er
med GridBagLayout, som l&aelig;gger komponenterne efter et usynligt
gitter. Hver komponent kan fylde en eller flere celler i h&oslash;jden
eller bredden.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog12_html_m2c9a4d37.png" NAME="Grafik33" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western">import java.awt.*;
import javax.swing.*;

public class PanelMedGridBagLayout extends JPanel
{
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JButton   knap1 = new JButton();
  JButton   knap2 = new JButton();
  JButton   knap3 = new JButton();
  JButton   knap4 = new JButton();
  JButton   knap5 = new JButton();
  JCheckBox chkH&oslash; = new JCheckBox();
  JCheckBox chkVe = new JCheckBox();
  JCheckBox chkCe = new JCheckBox();
  JTextArea tekst = new JTextArea();

  public PanelMedGridBagLayout() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    knap1.setText(&quot;knap1 (p&aring; 3x1 celler)&quot;);
    knap2.setText(&quot;knap2 (1x2)&quot;);
    knap3.setText(&quot;knap3 (p&aring; 1x1 celle)&quot;);
    knap4.setText(&quot;knap4 (1x1)&quot;);
    knap5.setText(&quot;knap5 (1x1)&quot;);
    chkH&oslash;.setText(&quot;H&oslash;jre&quot;);
    chkVe.setText(&quot;Venstre&quot;);
    chkCe.setText(&quot;Centreret&quot;);
    tekst.setColumns(15);
    tekst.setRows(2);
    tekst.setText(&quot;Tekstfelt (3x3 celler)&quot;);

    <B>this.setLayout(gridBagLayout1);</B>

<I>    // til sidst skal komponenterne f&oslash;jes til containeren</I>
<B>    this.add(knap1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, </B>
<B>    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));</B>
    this.add(knap2, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap4, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(knap5, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(chkH&oslash;, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
    GridBagConstraints.EAST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(chkVe, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
    GridBagConstraints.WEST,  GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(chkCe, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.NONE,new Insets(0,0,0,0),0,0));
    this.add(tekst, new GridBagConstraints(1, 2, 3, 3, 0.0, 0.0,
    GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
  }
}</PRE><P LANG="da-DK" CLASS="western">
N&aring;r en komponent tilf&oslash;jes, angives i et
GridBagConstraints-objekt:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Komponentens position
  (cellekolonne og -r&aelig;kke)</P>
  <LI><P LANG="da-DK" CLASS="western">Komponentens sp&aelig;ndvidde i
  h&oslash;jde og bredde 
  </P>
  <LI><P LANG="da-DK" CLASS="western">V&aelig;gt i h&oslash;jde og
  bredde (komponenter med st&oslash;rst v&aelig;rdi f&aring;r mest af
  eventuel overskydende plads)</P>
  <LI><P LANG="da-DK" CLASS="western">Justering i tilf&aelig;lde af
  overskydende plads (CENTER, EAST, WEST, NORTHEAST, ...)</P>
  <LI><P LANG="da-DK" CLASS="western">Om komponenten skal str&aelig;kkes
  til at fylde overskydende plads (BOTH, NONE, <BR>HORIZONTAL,
  VERTICAL)</P>
  <LI><P LANG="da-DK" CLASS="western">Til sidst nogle parametre til
  inds&aelig;ttelse af ekstra plads.</P>
</UL>
<P LANG="da-DK" CLASS="western">Her er koden, der viser vinduet.</P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytPanelMedGridBagLayout
{
  public static void main(String[] arg)
  {
    JFrame vindue = new JFrame( &quot;PanelMedGridBagLayout&quot; ); 
    vindue.add( new PanelMedGridBagLayout() );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
    vindue.pack();
    vindue.setVisible(true);
  }
}</PRE><H2 CLASS="western">
11.6 <a name='afsn11.6'></a>Menuer</SPAN></H2>
<P LANG="da-DK" CLASS="western" STYLE="; ">
En JFrame, JApplet og JDialog (men ikke JPanel og andre containere
som ikke er selvst&aelig;ndige vinduer) kan have en menubj&aelig;lke
med rullegardiner tilknyttet.</P>
<P LANG="da-DK" CLASS="western">Herunder har vi puttet en menu p&aring;
vinduet, der viser GrafikpanelMedKomponenter.</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_mf986856.png" NAME="grafik16" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Menuer er relativt enkle at lave: En
menubj&aelig;lke laves med new JMenuBar(), en menu (et rullegardin)
med new JMenu() og et menupunkt med new JMenuItem(). Derefter skal
menupunkterne tilf&oslash;jes menuerne, og menuerne f&oslash;jes til
menubj&aelig;lken (er det en undermenu f&oslash;jes den til
overmenuen) med add(). Man s&aelig;tter teksterne med setText(). Til
sidst s&aelig;ttes menubj&aelig;lken p&aring; vinduet ved at kalde
vindue.setJMenuBar(menubj&aelig;lke). 
</P>

<PRE CLASS="kode-western">import java.awt.event.*;
import javax.swing.*;

public class BenytGrafikpanelMedKomponenterOgMenu
{
  public static void main(String[] arg)
  {
    JFrame vindue = new JFrame( &quot;GrafikpanelMedKomponenterOgMenu&quot; ); 
    final GrafikpanelMedKomponenter panel = new GrafikpanelMedKomponenter();
    vindue.add( panel );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); 
    vindue.setSize(350,300);
<IMG SRC="bog12_html_mf986856.png" NAME="grafik17" ALIGN=RIGHT BORDER=0>
    <B>JMenuBar  menubj&aelig;lke = new JMenuBar()</B>;

    JMenu     rullegardinFil   = new JMenu();
    JMenuItem menupunktOpdat   = new JMenuItem();
    JMenuItem menupunktAfslut  = new JMenuItem();

    JMenu     rullegardinHj&aelig;lp = new JMenu();

    rullegardinFil.setText(&quot;Fil&quot;);
    rullegardinFil.setMnemonic(KeyEvent.VK_F);
    menupunktOpdat.setText(&quot;Opdater&quot;);
    menupunktAfslut.setText(&quot;Afslut&quot;);
    menupunktAfslut.setMnemonic(KeyEvent.VK_A);

    rullegardinHj&aelig;lp.setText(&quot;Hj&aelig;lp&quot;);

    rullegardinFil.add(menupunktOpdat);
    rullegardinFil.add(menupunktAfslut);
    menubj&aelig;lke.add(rullegardinFil);
    menubj&aelig;lke.add(rullegardinHj&aelig;lp);

    <B>vindue.setJMenuBar(menubj&aelig;lke)</B>;

    menupunktOpdat.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent e) {
        panel.buttonOpdater_actionPerformed(e);
      }
    });

    menupunktAfslut.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent e) {
        System.out.println(&quot;Farvel!&quot;);
        System.exit(0);
      }
    });

    vindue.setVisible(true); <I>// som det allersidste: vis vinduet</I>
  }
}</PRE><P LANG="da-DK" CLASS="western" STYLE="">
Man kan ogs&aring; s&aelig;tte genvejstaster p&aring; menuer, med
setMnemonic(). Disse aktiveres, som andre genvejstaster, med
Alt-tasten, s&aring;dan at Alt-F &aring;bner Fil-menuen.</P>
<P LANG="da-DK" CLASS="western">For at fange n&aring;r brugeren
v&aelig;lger et menupunkt, skal man lytte efter actionPerformed
ligesom med JButton-klassen (det blev diskuteret i <a href='kapitel11.jsp#afsn11.1.1'>afsnit 11.1.1</a>).</P>
<P LANG="da-DK" CLASS="western">Mere info:
<A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial/uiswing/components/menu.html">http://java.sun.com/docs/books/tutorial/uiswing/components/menu.html</A>
</P>


<H2 CLASS="western" STYLE="">11.7 <a name='afsn11.7'></a>Test dig
selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.7">
  <input type='checkbox' name='vis' value='11.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">11.8 <a name='afsn11.8'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.8">
  <input type='checkbox' name='vis' value='11.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">11.9 <a name='afsn11.9'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.9">
  <input type='checkbox' name='vis' value='11.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">11.9.1 <a name='afsn11.9.1'></a>HTML-kode i komponenter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.9.1">
  <input type='checkbox' name='vis' value='11.9.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.9.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">11.9.2 <a name='afsn11.9.2'></a>Flertr&aring;det
komponentprogrammering</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.9.2">
  <input type='checkbox' name='vis' value='11.9.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.9.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">11.9.3 <a name='afsn11.9.3'></a>Brug af komponenter vs. paintComponent()</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel11.jsp#afsn11.9.3">
  <input type='checkbox' name='vis' value='11.9.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.9.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
